/*
 * Decompiled with CFR 0.152.
 */
package com.charles445.simpledifficulty.register;

import com.charles445.simpledifficulty.api.SDPotions;
import com.charles445.simpledifficulty.config.ModConfig;
import com.charles445.simpledifficulty.potion.PotionHyperthermia;
import com.charles445.simpledifficulty.potion.PotionHypothermia;
import com.charles445.simpledifficulty.potion.PotionParasites;
import com.charles445.simpledifficulty.potion.PotionResistCold;
import com.charles445.simpledifficulty.potion.PotionResistHeat;
import com.charles445.simpledifficulty.potion.PotionThirsty;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.potion.PotionType;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class RegisterPotions {

    @Mod.EventBusSubscriber(modid="simpledifficulty")
    public static class Registrar {
        @SubscribeEvent
        public static void register(RegistryEvent.Register<Potion> event) {
            IForgeRegistry registry = event.getRegistry();
            SDPotions.hyperthermia = Registrar.registerAs("hyperthermia", new PotionHyperthermia(), (IForgeRegistry<Potion>)registry);
            SDPotions.hypothermia = Registrar.registerAs("hypothermia", new PotionHypothermia(), (IForgeRegistry<Potion>)registry);
            SDPotions.thirsty = Registrar.registerAs("thirsty", new PotionThirsty(), (IForgeRegistry<Potion>)registry);
            SDPotions.parasites = Registrar.registerAs("parasites", new PotionParasites(), (IForgeRegistry<Potion>)registry);
            SDPotions.cold_resist = Registrar.registerAs("cold_resist", new PotionResistCold(), (IForgeRegistry<Potion>)registry);
            SDPotions.heat_resist = Registrar.registerAs("heat_resist", new PotionResistHeat(), (IForgeRegistry<Potion>)registry);
        }

        @SubscribeEvent
        public static void registerTypes(RegistryEvent.Register<PotionType> event) {
            IForgeRegistry registry = event.getRegistry();
            SDPotions.cold_resist_type = Registrar.registerTypeAs("cold_resist_type", SDPotions.cold_resist, ModConfig.server.miscellaneous.resistancePotionDurationShort, (IForgeRegistry<PotionType>)registry);
            SDPotions.long_cold_resist_type = Registrar.registerTypeAs("long_cold_resist_type", SDPotions.cold_resist, ModConfig.server.miscellaneous.resistancePotionDurationLong, (IForgeRegistry<PotionType>)registry);
            SDPotions.heat_resist_type = Registrar.registerTypeAs("heat_resist_type", SDPotions.heat_resist, ModConfig.server.miscellaneous.resistancePotionDurationShort, (IForgeRegistry<PotionType>)registry);
            SDPotions.long_heat_resist_type = Registrar.registerTypeAs("long_heat_resist_type", SDPotions.heat_resist, ModConfig.server.miscellaneous.resistancePotionDurationLong, (IForgeRegistry<PotionType>)registry);
        }

        private static PotionType registerTypeAs(String name, Potion potion, int duration, IForgeRegistry<PotionType> registry) {
            PotionType potionType = new PotionType(new PotionEffect[]{new PotionEffect(potion, duration)});
            potionType.setRegistryName("simpledifficulty", name);
            registry.register((IForgeRegistryEntry)potionType);
            SDPotions.potionTypes.put(name, potionType);
            return potionType;
        }

        private static Potion registerAs(String name, Potion potion, IForgeRegistry<Potion> registry) {
            potion.setRegistryName("simpledifficulty", name);
            potion.func_76390_b("effect." + name);
            registry.register((IForgeRegistryEntry)potion);
            SDPotions.potions.put(name, potion);
            return potion;
        }
    }
}

